{========================================================================}
{=                (c) 1995-99 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 22.03.99 - 15:52:06 $                                        =}
{========================================================================}
unit CDDBSel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TCDDBSelectDlg = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Header: THeader;
    ListBox: TListBox;
    btnCancel: TButton;
    Label1: TLabel;
    procedure HeaderSized(Sender: TObject; ASection, AWidth: Integer);
    procedure ListBoxDrawItem(Control: TWinControl; Index: Integer; R: TRect; State: TOwnerDrawState);
    procedure FormCreate(Sender: TObject);
    procedure ListBoxMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  private
  public
    SelectedItem: integer;
  end;

var
  CDDBSelectDlg: TCDDBSelectDlg;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TCDDBSelectDlg.FormCreate(Sender: TObject);
begin
   SelectedItem := -1;
end;

{------------------------------------------------------------------------------}
procedure TCDDBSelectDlg.HeaderSized(Sender: TObject; ASection,AWidth: Integer);
begin
   ListBox.Invalidate;
end;

{------------------------------------------------------------------------------}
procedure TCDDBSelectDlg.ListBoxDrawItem(Control: TWinControl; Index: Integer; R: TRect; State: TOwnerDrawState);
var
  P,Offset,i: Integer;
  C: array[0..255] of Char;
  S,S2: string;
begin
   Offset := 0;
   i := 0;

   S2 := ListBox.Items[Index];

   { find the separator in the string }
   P := Pos(#9, S2);
   while True do
   begin
      { draw the item }
      if (P = 0) then S := System.Copy(S2, 1, MaxInt)
      else S := System.Copy(S2, 1, P-1);

      R.Right := R.Left + (Header.SectionWidth[i]);
      ExtTextOut(ListBox.Canvas.Handle, R.Left, R.Top, ETO_CLIPPED or
                 ETO_OPAQUE, @R, StrPCopy(C, S), Length(S), nil);

      { move the rectangle to the next column }
      if (i = 0) then dec(R.Right,Offset);
      R.Left := R.Right;

      if (P = 0) then exit;

      S2 := System.Copy(S2, P+1, MaxInt);
      { find the next separator in the string }
      P := Pos(#9, S2);
      inc(i);
   end;
end;

{------------------------------------------------------------------------------}
procedure TCDDBSelectDlg.ListBoxMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   SelectedItem := ListBox.ItemAtPos(Point(X,Y),True);
   ModalResult := mrOK;
end;

end.
